# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


Name:           nodejs-npm-registry-client
Version:        8.6.0
Release:        alt1_1
Summary:        Client for the npm registry

Group:          System/Libraries
License:        BSD
URL:            https://github.com/isaacs/npm-registry-client
Source0:        https://registry.npmjs.org/npm-registry-client/-/npm-registry-client-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh
BuildArch:      noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:  %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(tap)
BuildRequires:  npm(concat-stream)
BuildRequires:  npm(graceful-fs)
BuildRequires:  npm(negotiator)
#BuildRequires:  npm(nock)
BuildRequires:  npm(normalize-package-data)
BuildRequires:  npm(npm-package-arg)
BuildRequires:  npm(npmlog)
BuildRequires:  npm(once)
BuildRequires:  npm(readable-stream)
BuildRequires:  npm(request)
BuildRequires:  npm(retry)
BuildRequires:  npm(rimraf)
BuildRequires:  npm(semver)
Source44: import.info

%description
Client for the npm registry, or private servers using the npm registry software.


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package


%nodejs_fixdep request "^2.25.0"
%nodejs_fixdep retry "^0.8.0"


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/npm-registry-client
cp -pr package.json index.js lib %{buildroot}%{nodejs_sitelib}/npm-registry-client
%nodejs_symlink_deps


%check
%{nodejs_symlink_deps} --check
# optional dependency, but needed for tests
ln -s %{nodejs_sitelib}/npmlog node_modules
# needs npm(nock)
#rm test/star.js
#Tests disabled, as our version of npm(tap) in Fedora is too old
#%tap test/*.js


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/npm-registry-client


%changelog
