Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename pad-left
%global enable_tests 1

Name:		nodejs-pad-left
Version:	2.1.0
Release:	alt1_9
Summary:	Left pad a string with zeros or a specified string

License:	MIT
URL:		https://github.com/jonschlinkert/pad-left.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/jonschlinkert/pad-left/master/test.js

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(repeat-string)
%if 0%{?enable_tests}
BuildRequires:	npm(mocha)
BuildRequires:	npm(should)
%endif
Source44: import.info

%description
Left pad a string with zeros or a specified string. Fastest implementation.


%prep
%setup -q -n package
# setup the tests
cp -p %{SOURCE1} .

# fix the script interpreter
sed -i '1i #!/usr/bin/node' index.js

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"

%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}


%changelog
