Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-parseurl
Version:    1.3.2
Release:    alt1_6
Summary:    Parse a URL with memoization
License:    MIT
URL:        https://github.com/expressjs/parseurl
Source0:    http://registry.npmjs.org/parseurl/-/parseurl-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:  mocha node-mocha
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package



%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/parseurl
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/parseurl

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec --check-leaks --bail
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/parseurl


%changelog
