Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global enable_tests 1

Name:           nodejs-passport-oauth
Version:        1.0.0
Release:        alt1_11
Summary:        OAuth 1.0 and 2.0 authentication strategies for Passport

License:        MIT
URL:            https://github.com/jaredhanson/passport-oauth
Source0:        http://registry.npmjs.org/passport-oauth/-/passport-oauth-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated using Source10, which pulls from the upstream
# version control repository.
Source1:        passport-oauth-tests-v%{version}.tar.bz2
Source10:       passport-oauth-dl-tests.sh
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
BuildRequires:  npm(chai)
BuildRequires:  npm(chai-passport-strategy)
BuildRequires:  npm(passport-oauth1)
BuildRequires:  npm(passport-oauth2)
%endif
Source44: import.info

%description
General-purpose OAuth 1.0 and OAuth 2.0 authentication strategies for
Passport.

This module lets you authenticate using OAuth in your Node.js
applications. By plugging into Passport, OAuth authentication can be
easily and unobtrusively integrated into any application or framework
that supports Connect-style middleware, including Express.

Note that this strategy provides generic OAuth support. In many cases,
a provider-specific strategy can be used instead, which cuts down on
unnecessary configuration, and accommodates any provider-specific
quirks. See the list below for supported providers.


%prep
%setup -q -n package
%setup -T -D -a 1 -q -n package
rm -rf node_modules


%build


%install
mkdir -p %{buildroot}/%{nodejs_sitelib}/passport-oauth
cp -pr package.json lib %{buildroot}/%{nodejs_sitelib}/passport-oauth
%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/mocha/bin/mocha --reporter spec --require test/bootstrap/node test/*.test.js
%endif


%files
%doc LICENSE README.md
%{nodejs_sitelib}/passport-oauth


%changelog
