Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# some testing dependencies not yet in Fedora
%global enable_tests 1

Name:       nodejs-q
Version:    1.5.1
Release:    alt1_4
Summary:    A tool for making and composing asynchronous promises in JavaScript
# q.js appears to contain both MIT and ASL 2.0 licensed code
License:    MIT and ASL 2.0
URL:        https://github.com/kriskowal/q
Source0:    http://registry.npmjs.org/q/-/q-%{version}.tgz
# Sources 1-2 are generated by running Source10, which pulls from the upstream
# revision control repository.
Source1:    tests-%{version}.tar.bz2
Source2:    examples-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  jasmine-node
BuildRequires:  npm(promises-aplus-tests)
%endif
Source44: import.info

%description
Q is a tool for making and composing asynchronous promises in JavaScript.

If a function cannot return a value or throw an exception without blocking,
it can return a promise instead. A promise is an object that represents the
return value or the thrown exception that the function may eventually provide.
A promise can also be used as a proxy for a remote object to overcome latency.

Q can exchange promises with jQuery, Dojo, When.js, WinJS, and more.
Additionally, there are many libraries that produce and consume Q promises for
everything from file system/database access or RPC to templating.


%prep
%setup -q -n package
%setup -q -D -T -a 1 -n package
%setup -q -D -T -a 2 -n package


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/q
cp -pr package.json *.js \
    %{buildroot}%{nodejs_sitelib}/q

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/jasmine-node spec
#%{_bindir}/promises-aplus-tests spec/aplus-adapter
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md examples/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/q


%changelog
