Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename read-json-sync
%global enable_tests 1
%global upstream_version 2.0.0-1

Name:		nodejs-read-json-sync
Version:	2.0.0.1
Release:	alt1_5
Summary:	Read and parse a JSON file synchronously

License:	CC0
URL:		https://github.com/shinnn/read-json-sync
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{upstream_version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(graceful-fs)

%if 0%{?enable_tests}
BuildRequires:	npm(tap-spec)
BuildRequires:	npm(tape)
%endif
Source44: import.info

%description
Read and parse a JSON file synchronously


%prep
%setup -q -n package

# setup the tests
%setup -q -T -D -a 1 -n package


%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%__nodejs test/test.js | tap-spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%{nodejs_sitelib}/%{packagename}

%changelog
