Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global enable_tests 0
# Tests disabled due to missing npm(babel-polyfill)

%global packagename readable-stream
%global owner nodejs

Name:               nodejs-readable-stream
Version:            2.3.6
Release:            alt1_3
Summary:            Streams3, a user-land copy of the stream library from Node.js

License:            MIT
URL:                https://www.npmjs.org/package/readable-stream
Source0:            https://github.com/%{owner}/%{packagename}/archive/v%{version}/%{packagename}-%{version}.tar.gz
BuildArch:          noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel

BuildRequires:      npm(core-util-is)
BuildRequires:      npm(inherits)
BuildRequires:      npm(isarray)
BuildRequires:      npm(process-nextick-args)
BuildRequires:      npm(safe-buffer)
BuildRequires:      npm(string_decoder)
BuildRequires:      npm(util-deprecate)

%if 0%{?enable_tests}
BuildRequires:      npm(babel-polyfill)
BuildRequires:      npm(tap)
BuildRequires:      npm(tape)
%endif
Source44: import.info


%description
This package is a mirror of the Streams2 and Streams3 implementations in
Node-core.

%prep
%setup -q -n %{packagename}-%{version}


# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep isarray '~0.0.1'
%nodejs_fixdep string_decoder '~0.10.1'

%build
#nothing to build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/readable-stream
cp -pr package.json lib *.js \
    %{buildroot}%{nodejs_sitelib}/readable-stream

%nodejs_symlink_deps

%check
exit 0
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
tap test/parallel/*.js test/ours/*.js
%endif

%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/readable-stream/

%changelog
