Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:           nodejs-readdirp
Version:        2.1.0
Release:        alt1_8
Summary:        Recursive version of Node's fs.readdir with a streaming API

License:        MIT
URL:            https://github.com/thlorenz/readdirp
Source0:        https://registry.npmjs.org/readdirp/-/readdirp-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:        tests-v%{version}.tar.bz2
Source10:       dl-tests.sh
# https://github.com/thlorenz/readdirp/pull/38
Patch0:         nodejs-readdirp-pause.patch

BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(graceful-fs)
BuildRequires:  npm(minimatch)
BuildRequires:  npm(proxyquire)
BuildRequires:  npm(readable-stream)
BuildRequires:  npm(set-immediate-shim)
BuildRequires:  npm(tap)
BuildRequires:  npm(through2)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
# The NPM tarball is missing some files within test/
rm -rf test/
%setup -q -T -D -a 1 -n package
# Apply patches
%patch0 -p1
# Remove executable bit.
find . -type f -exec chmod -x '{}' \;
# Fix dependencies
%nodejs_fixdep minimatch "^3.0.0"


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/readdirp
cp -pr package.json readdirp.js stream-api.js \
    %{buildroot}%{nodejs_sitelib}/readdirp

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%__tap test/*.js
%endif


%files
%doc README.md examples/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/readdirp


%changelog
