Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:          nodejs-request
Version:       2.67.0
Release:       alt1_14
Summary:       Simplified HTTP request client
License:       ASL 2.0
URL:           https://github.com/request/request
Source0:       https://github.com/request/request/archive/v%{version}/request-%{version}.tar.gz
BuildArch:     noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(aws-sign2)
BuildRequires:  npm(bl)
BuildRequires:  npm(caseless)
BuildRequires:  npm(combined-stream)
BuildRequires:  npm(extend)
BuildRequires:  npm(forever-agent)
BuildRequires:  npm(form-data)
BuildRequires:  npm(har-validator)
BuildRequires:  npm(hawk)
BuildRequires:  npm(http-signature)
BuildRequires:  npm(is-typedarray)
BuildRequires:  npm(isstream)
BuildRequires:  npm(json-stringify-safe)
BuildRequires:  npm(mime-types)
BuildRequires:  npm(node-uuid)
BuildRequires:  npm(oauth-sign)
BuildRequires:  npm(qs)
BuildRequires:  npm(stringstream)
BuildRequires:  npm(tough-cookie)
BuildRequires:  npm(tunnel-agent)

%if 0%{?enable_tests}
BuildRequires:  npm(tape)
BuildRequires:  npm(bluebird)
BuildRequires:  npm(buffer-equal)
BuildRequires:  npm(rimraf)
#BuildRequires:  npm(server-destroy)
%endif
Source44: import.info

%description
Request is designed to be the simplest way possible to make HTTP calls. It
supports HTTPS and follows redirects by default.

You can stream any response to a file stream. You can also stream a file to a
PUT or POST request.  It also supports a few simple server and proxy functions.


%prep
%setup -q -n request-%{version}

%{nodejs_fixdep} aws-sign2 "^0.7.0"
%{nodejs_fixdep} bl "^1.0.0"
%{nodejs_fixdep} form-data "^0.2.0"
%{nodejs_fixdep} hawk "^4.0.1"
%{nodejs_fixdep} http-signature "^0.10.0"
%{nodejs_fixdep} qs "^6.0.1"
%{nodejs_fixdep} tough-cookie "^2.3.1"
chmod -x index.js
rm -rf node_modules


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/request
cp -pr package.json index.js request.js lib %{buildroot}%{nodejs_sitelib}/request
%nodejs_symlink_deps


%check
%{nodejs_symlink_deps} --check
%__nodejs -e "require('./')"
%if 0%{?enable_tests}
# needs npm(server-destroy)
rm tests/test-tunnel.js
tape tests/test-*.js
%endif


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/request


%changelog
