Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-requirejs
Version:    2.1.11
Release:    alt1_12
Summary:    Node.js adapter for RequireJS, for loading AMD modules
License:    MIT or BSD
URL:        https://github.com/jrburke/r.js
Source0:    http://registry.npmjs.org/requirejs/-/requirejs-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 and Source2 are generated by running Source10, which pulls from
# the upstream version control repository.
Source1:    tests-%{version}.tar.bz2
Source2:    build-%{version}.tar.bz2
Source10:   dl-tests.sh
# License is included in upstream version control repository:
# https://github.com/jrburke/r.js/commits/master/LICENSE
Source20:   LICENSE

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
Source44: import.info

%description
RequireJS is a JavaScript file and module loader. It is optimized for
in-browser use, but it can be used in other JavaScript environments,
like Rhino and Node. Using a modular script loader like RequireJS will
improve the speed and quality of your code.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
%setup -q -T -D -a 2 -n package
cp -p %{SOURCE20} .


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/requirejs
cp -pr package.json require.js \
    %{buildroot}%{nodejs_sitelib}/requirejs
mkdir -p %{buildroot}%{nodejs_sitelib}/requirejs/bin
install -p -D -m0755 bin/r.js \
    %{buildroot}%{nodejs_sitelib}/requirejs/bin/r.js

mkdir -p %{buildroot}%{_bindir}
ln -s %{nodejs_sitelib}/requirejs/bin/r.js \
    %{buildroot}%{_bindir}/r.js

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
pushd tests/
%__nodejs ../bin/r.js all.js
popd
%endif


%files
%doc LICENSE README.md
%{nodejs_sitelib}/requirejs
%{_bindir}/r.js


%changelog
