Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


Name:           nodejs-rewire
Version:        2.5.2
Release:        alt1_8
Summary:        Easy dependency injection for node.js unit testing

License:        MIT
URL:            https://www.npmjs.com/package/rewire
Source0:        https://github.com/jhnns/rewire/archive/v%{version}/%{name}-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(mocha)
BuildRequires:  npm(coffee-script)
BuildRequires:  npm(expect.js)
Source44: import.info


%description
Rewire adds a special setter and getter to modules so you can
modify their behavior for better unit testing. You may:

* Inject mocks for other modules or globals like process
* Leak private variables
* Override variables within the module.

Rewire does not load the file and eval the contents to emulate
node's require mechanism. In fact it uses node's own require to
load the module. Thus your module behaves exactly the same in
your test environment as under regular circumstances (except
your modifications).


%prep
%setup -q -n rewire-%{version}

rm -rf node_modules


%build


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/rewire
cp -pr package.json lib %{buildroot}%{nodejs_sitelib}/rewire
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/mocha/bin/mocha -R spec --check-leaks


%files
%doc README.md CHANGELOG.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/rewire


%changelog
