Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global enable_tests 0

%global barename sauce-tunnel

Name:               nodejs-sauce-tunnel
Version:            2.2.3
Release:            alt1_9
Summary:            A wrapper around the Sauce Labs tunnel jar

License:            MIT
URL:                https://www.npmjs.org/package/sauce-tunnel
Source0:            https://registry.npmjs.org/%{barename}/-/%{barename}-%{version}.tgz
BuildArch:          noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:      npm(chalk)
BuildRequires:      npm(request)
%endif
Source44: import.info


%description
A Node.js wrapper around the Saucelabs tunnel jar.

%prep
%setup -q -n package

# Remove bundled node_modules if there are any..
rm -rf node_modules/
rm -rf vendor/

%nodejs_fixdep --caret
%nodejs_fixdep chalk
%nodejs_fixdep split

%build
# Nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/sauce-tunnel
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/sauce-tunnel

%nodejs_symlink_deps


%check
%if 0%{?enable_tests}
%nodejs_symlink_deps --check
node ./test/sanity
%endif


%files
%doc README.md
%doc --no-dereference LICENSE-MIT
%{nodejs_sitelib}/sauce-tunnel/

%changelog
