Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-sax
Version:    0.6.0
Release:    alt1_11
Summary:    A streaming SAX-style XML parser in JavaScript for Node.js
License:    BSD and W3C
URL:        https://github.com/isaacs/sax-js
Source0:    http://registry.npmjs.org/sax/-/sax-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
Source44: import.info

%description
This is a SAX-style streaming XML parser in JavaScript for Node.js.

It is:
 - A very simple tool to parse through an XML string.
 - A stepping stone to a streaming HTML parser.
 - A handy way to deal with RSS and other mostly-ok-but-kinda-broken XML docs.


%prep
%setup -q -n package


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/sax
cp -pr package.json lib/ %{buildroot}%{nodejs_sitelib}/sax
rm -f examples/switch-bench.js

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%__nodejs test/index.js
%endif


%files
%doc AUTHORS LICENSE LICENSE-W3C.html README.md examples/
%{nodejs_sitelib}/sax


%changelog
