Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-should
Version:    8.4.0
Release:    alt1_9
Summary:    A test framework agnostic BDD-style assertions for Node.js
# License text is included in Readme.md
License:    MIT
URL:        https://github.com/shouldjs/should.js
Source0:    https://registry.npmjs.org/should/-/should-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

# should-promised is now part of should
Obsoletes:  nodejs-should-promised < 0.3.1-2

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
BuildRequires:  npm(bluebird)
BuildRequires:  npm(should-equal)
BuildRequires:  npm(should-format)
BuildRequires:  npm(should-type)
%endif

Patch0001: 0001-Fix-flaky-tests.patch
Source44: import.info

%description
should is an expressive, readable, test framework agnostic, behavior-driven
development (BDD)-style assertion library for Node.js.

It extends the Object prototype with a single non-enumerable getter that
allows you to express how that object should behave.

should literally extends Node's assert module. For example,
should.equal(str, 'foo') will work, just as assert.equal(str, 'foo') would,
and should.AssertionError is assert.AssertionError, meaning any test framework
supporting this constructor will function properly with should.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
%patch0001 -p1
rm -f should.min.js
find . -type f -exec chmod -x '{}' \;


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/should
cp -pr package.json index.js lib/ should.js \
    %{buildroot}%{nodejs_sitelib}/should

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/mocha/bin/mocha --ui exports test/**/*.test.js
%endif


%files
%doc Readme.md History.md CONTRIBUTING.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/should


%changelog
