Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename sinon-chai
%global enable_tests 1

Name:		nodejs-sinon-chai
Version:	2.14.0
Release:	alt1_5
Summary:	Extends Chai with assertions for the Sinon.JS mocking framework

License:	BSD or WTFPL
URL:		https://github.com/domenic/sinon-chai.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(chai)
BuildRequires:	npm(sinon)

%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	coffee-script
%endif
Source44: import.info

%description
Extends Chai with assertions for the Sinon.JS mocking framework.


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc *.md
%doc --no-dereference LICENSE.txt
%{nodejs_sitelib}/%{packagename}

%changelog
