Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nodejs-sqlite3
Version:        4.2.0
Release:        alt3_1
Summary:        Asynchronous, non-blocking SQLite3 bindings for Node.js

License:        BSD
URL:            https://github.com/mapbox/node-sqlite3
Source0:        https://github.com/mapbox/node-sqlite3/archive/v%{version}/%{name}-%{version}.tar.gz
# Patch out use node-pre-gyp
Patch0:         nodejs-sqlite3-pregyp.patch
# Patch out setting of rpath
Patch1:         nodejs-sqlite3-rpath.patch
# Fix for mocha 2.x support
Patch2:         nodejs-sqlite3-mocha.patch

BuildRequires:  node-devel rpm-build-nodejs
BuildRequires:  node-gyp
BuildRequires:  libsqlite3-devel >= 3.10.2

BuildRequires:  npm(nan) >= 2.12.1
BuildRequires:  npm(mocha)

%{?nodejs_default_filter}
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n node-sqlite3-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1

%nodejs_fixdep --dev --move nan
rm -rf deps/* node_modules
echo "{}" > deps/common-sqlite.gypi


%build
%nodejs_symlink_deps --build

node-gyp configure -- -Dsqlite=/usr -Dmodule_name=node_sqlite3 -Dmodule_path=lib/binding
node-gyp build


%install
mkdir -p %{buildroot}/%{nodejs_sitearch}/sqlite3
cp -pr package.json lib %{buildroot}/%{nodejs_sitearch}/sqlite3
%nodejs_symlink_deps


%check
%ifnarch s390x
%nodejs_symlink_deps --check
%{__nodejs} test/support/createdb.js
mkdir test/tmp
NODE_PATH=lib %{nodejs_sitelib}/mocha/bin/mocha -R spec -t 1000000
%endif


%files
%doc README.md CHANGELOG.md examples
%doc --no-dereference LICENSE
%{nodejs_sitearch}/sqlite3


%changelog
