Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename tap-spec
%global enable_tests 1

Name:		nodejs-tap-spec
Version:	4.1.1
Release:	alt1_6
Summary:	Formatted TAP output like Mocha's spec reporter

License:	MIT
URL:		https://github.com/scottcorgan/tap-spec.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# No license file upstream, requested at https://github.com/scottcorgan/tap-spec/issues/46
Source1:	LICENSE-MIT.txt

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(chalk)
BuildRequires:	npm(duplexer)
BuildRequires:	npm(figures)
BuildRequires:	npm(lodash)
BuildRequires:	npm(pretty-ms)
BuildRequires:	npm(repeat-string)
BuildRequires:	npm(tap-out)
BuildRequires:	npm(through2)
%if 0%{?enable_tests}
BuildRequires:	npm(tap)
BuildRequires:	npm(tapes)
%endif
Source44: import.info

%description
Formatted TAP output like Mocha's spec reporter


%prep
%setup -q -n package
# copy the license file
cp -p %{SOURCE1} .

sed -i '1s/env //' bin/cmd.js

%nodejs_fixdep tap-out

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}/bin
install -p -D -m0755 bin/cmd.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}/bin/cmd.js

mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/%{packagename}/bin/cmd.js \
    %{buildroot}%{_bindir}/tap-spec

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
# see package.json
%{_bindir}/tap test/**/*.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"

%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE-MIT.txt
%{nodejs_sitelib}/%{packagename}
%{_bindir}/tap-spec


%changelog
