Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:           nodejs-tape
Version:        4.9.0
Release:        alt1_6
Summary:        Tap-producing test harness for Node.js and browsers

License:        MIT
URL:            https://github.com/substack/tape
Source0:        http://registry.npmjs.org/tape/-/tape-%{version}.tgz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  npm(for-each)

%if 0%{?enable_tests}
BuildRequires:  npm(concat-stream)
BuildRequires:  npm(defined)
BuildRequires:  npm(deep-equal) >= 0.2.1
#BuildRequires:  npm(falafel)
BuildRequires:  npm(function-bind)
BuildRequires:  npm(has)
BuildRequires:  npm(js-yaml)
BuildRequires:  npm(jsonify)
BuildRequires:  npm(minimist)
BuildRequires:  npm(object-inspect)
BuildRequires:  npm(resolve)
BuildRequires:  npm(resumer)
BuildRequires:  npm(string.prototype.trim)
BuildRequires:  npm(tap)
BuildRequires:  npm(tap-parser)
BuildRequires:  npm(through)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%nodejs_fixdep glob "^6.0.4"
%nodejs_fixdep inherits "^2.0.1"
%nodejs_fixdep object-inspect "^1.1.0"
%nodejs_fixdep resolve "^1.7.1"
%nodejs_fixdep string.prototype.trim "^1.2.0"


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/tape
cp -pr package.json index.js lib/ \
    %{buildroot}%{nodejs_sitelib}/tape

mkdir -p %{buildroot}%{nodejs_sitelib}/tape/bin
install -p -D -m0755 bin/tape %{buildroot}%{nodejs_sitelib}/tape/bin/tape
mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/tape/bin/tape %{buildroot}%{_bindir}/tape

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%__nodejs -e "require('./')"
%if 0%{?enable_tests}
# remove tests which need nodejs-falafel
rm test/array.js test/exit.js test/fail.js test/nested.js test/too_many.js
# remove tests which need newer tap
rm test/require.js
%tap test/*.js
%endif


%files
%doc readme.markdown
%doc --no-dereference LICENSE
%{nodejs_sitelib}/tape
%{_bindir}/tape


%changelog
