Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename tapes
%global enable_tests 1

Name:		nodejs-tapes
Version:	4.1.0
Release:	alt1_6
Summary:	A more robust tap-producing test harness for node and browsers

License:	MIT
URL:		https://github.com/scottcorgan/tapes
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/scottcorgan/tapes/master/test/tapes.js
# License file requested upstream at https://github.com/scottcorgan/tapes/pull/17
Source2:	LICENSE

BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	npm(async)
BuildRequires:	npm(tap)
BuildRequires:	npm(tape)
%endif
Source44: import.info

%description
A more robust tap-producing test harness for node and browsers. Adds
beforeEach, afterEach, etc.


%prep
%setup -q -n package

# setup the tests
mkdir test
cp -p %{SOURCE1} test/
# copy the license file
cp -p %{SOURCE2} .

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
ln -sf %{nodejs_sitelib}/tape node_modules/tape
%{_bindir}/tap test/tapes.js
./bin/tapes test/tapes.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
