Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:           nodejs-temp
Version:        0.8.3
Release:        alt1_9
Summary:        Temporary files and directories for Node.js
License:        MIT
URL:            https://github.com/bruce/node-temp
Source0:        https://registry.npmjs.org/temp/-/temp-%{version}.tgz
BuildArch:      noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:  %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(os-tmpdir)
BuildRequires:  npm(rimraf)
%endif
Source44: import.info

%description
This Node.js module handles generating a unique file/directory name under the
appropriate system temporary directory, changing the file to an appropriate
mode, and supports automatic removal.

It has a similar API to the fs module.


%prep
%setup -q -n package
%nodejs_fixdep rimraf "^2.2.6"


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/temp
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/temp
%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%__nodejs test/temp-test.js
%endif


%files
%doc README.md examples/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/temp


%changelog
