Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# This is a fork of the original tiny-lr: <https://github.com/mklabs/tiny-lr>.
# The maintainer of the fork has stated that the fork is only temporary and
# will cease to exist once the maintainer of the original software springs
# back to life. The fork has gained favour among other modules, notably the
# Grunt project, so we will ship the fork with the intention of Obsoleting it
# once the original tiny-lr has been revived.

# Versions of connect and express used in the test suite are outdated.
%global enable_tests 0

Name:       nodejs-tiny-lr-fork
Version:    0.0.5
Release:    alt1_15
Summary:    A tiny LiveReload server implementation you can spawn in the background
License:    MIT
URL:        https://github.com/shama/tiny-lr
Source0:    https://registry.npmjs.org/tiny-lr-fork/-/tiny-lr-fork-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(connect)
BuildRequires:  npm(debug)
BuildRequires:  npm(express)
BuildRequires:  npm(faye-websocket)
BuildRequires:  npm(mocha)
BuildRequires:  npm(noptify)
BuildRequires:  npm(qs)
BuildRequires:  npm(request)
BuildRequires:  npm(supertest)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package

%nodejs_fixdep faye-websocket '~0.7'
%nodejs_fixdep qs '^6.0.2'
%nodejs_fixdep noptify '~0.0.3'
%nodejs_fixdep debug '^2.2.0'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/tiny-lr-fork
cp -pr package.json lib/ tasks/ \
    %{buildroot}%{nodejs_sitelib}/tiny-lr-fork

mkdir -p %{buildroot}%{nodejs_sitelib}/tiny-lr-fork/bin
install -p -m755 bin/tiny-lr \
    %{buildroot}%{nodejs_sitelib}/tiny-lr-fork/bin/tiny-lr
install -p -m755 bin/update-livereload \
    %{buildroot}%{nodejs_sitelib}/tiny-lr-fork/bin/update-livereload

mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/tiny-lr-fork/bin/tiny-lr \
    %{buildroot}%{_bindir}/tiny-lr
ln -sf %{nodejs_sitelib}/tiny-lr-fork/bin/update-livereload \
    %{buildroot}%{_bindir}/update-livereload

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
/usr/bin/mocha --reporter spec
%endif


%files
%doc readme.md
%doc --no-dereference LICENSE-MIT
%{nodejs_sitelib}/tiny-lr-fork
%{_bindir}/tiny-lr
%{_bindir}/update-livereload


%changelog
