Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename try-open
%global enable_tests 1

Name:		nodejs-try-open
Version:	0.1.3
Release:	alt1_8
Summary:	Tries to open a file using fs.openSync, fails gracefully

License:	MIT
URL:		https://github.com/jonschlinkert/try-open
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Releases haven't been tagged in Github, so pull tests from master
Source1:	https://raw.githubusercontent.com/jonschlinkert/try-open/master/test.js


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif
Source44: import.info

%description
Tries to open a file using fs.openSync (only necessary with sync), fails
gracefully if the file path does not exist on the file system. Since
fs.existsSync has been deprecated, this can be used as an alternative.


%prep
%setup -q -n package

# setup the tests
cp -p %{SOURCE1} .

mkdir fixtures
touch fixtures/a.txt

%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
