Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename tv4
%global enable_tests 1

Name:		nodejs-tv4
Version:	1.3.0
Release:	alt1_5
Summary:	A public domain JSON Schema validator for JavaScript

License:	MIT AND Public Domain
URL:		https://github.com/geraintluff/tv4.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh

# component.json and bower.json files needed for tests, v1.3.0 isn't tagged, so
# we'll pull from master
Source11:	https://raw.githubusercontent.com/geraintluff/tv4/master/component.json
Source12:	https://raw.githubusercontent.com/geraintluff/tv4/master/bower.json

# Patch the tests to use a newer npm(proclaim) assertion library
Patch0:		nodejs-tv4_use-newer-proclaim.patch

BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(proclaim)

%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(source-map-support)
%endif
Source44: import.info

%description
A public domain JSON Schema validator for JavaScript


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package
cp -p %{SOURCE11} .
cp -p %{SOURCE12} .

%patch0 -p1


%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js lang/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc *.md
%doc --no-dereference LICENSE.txt
%{nodejs_sitelib}/%{packagename}

%changelog
