Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global npmname tweetnacl

Name:           nodejs-%{npmname}
Version:        1.0.1
Release:        alt1_3
Summary:        Port of TweetNaCl cryptographic library to JavaScript

License:        Unlicense
URL:            https://www.npmjs.com/package/%{npmname}

# NPM does not include tests.
Source0:        https://github.com/dchest/tweetnacl-js/archive/v%{version}/%{npmname}-%{version}.tar.gz

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  nodejs-tape
BuildRequires:  nodejs-tweetnacl-util
BuildRequires:  uglify-js

# Some of the tests are written in C.
BuildRequires:  gcc

BuildArch:      noarch
Source44: import.info

%description
The primary goal of this project is to produce a translation of TweetNaCl
to JavaScript which is as close as possible to the original C
implementation, plus a thin layer of idiomatic high-level API on top of it.

There are two versions, you can use either of them:

nacl.js is the port of TweetNaCl with minimum differences from the original
+ high-level API.

nacl-fast.js is like nacl.js, but with some functions replaced with faster
versions. (Used by default when importing NPM package.)

%prep
%setup -q -n tweetnacl-js-%{version}


%build
# We need to uglify some sources. :/
uglifyjs nacl.js -c -m -o nacl.min.js
uglifyjs nacl-fast.js -c -m -o nacl-fast.min.js

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{npmname}
cp -a *.js %{buildroot}%{nodejs_sitelib}/%{npmname}/
cp -a *.ts %{buildroot}%{nodejs_sitelib}/%{npmname}/
cp -a package.json %{buildroot}%{nodejs_sitelib}/%{npmname}/

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
make -C test/c
tape test/*.js test/c/*.js

%files
%{nodejs_sitelib}/%{npmname}/
%doc --no-dereference LICENSE
%doc README.md AUTHORS.md CHANGELOG.md

%changelog
