Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global npm_name ultron
# Although there are tests
# the dependancies aren't in Fedora yet
%global enable_tests 0



Summary:       Ultron is a high-intelligence robot
Name:          nodejs-%{npm_name}
Version:       1.1.1
Release:       alt1_7
License:       MIT
URL:           https://github.com/unshiftio/ultron
Source0:       http://registry.npmjs.org/%{npm_name}/-/%{npm_name}-%{version}.tgz
Source1:       https://raw.githubusercontent.com/unshiftio/ultron/%{version}/test.js
Source2:       https://raw.githubusercontent.com/unshiftio/ultron/%{version}/README.md

BuildRequires: node-devel rpm-build-nodejs
%if 0%{?enable_tests}
BuildRequires:  npm(assume)
BuildRequires:  npm(eventemitter3)
BuildRequires:  npm(istanbul)
BuildRequires:  npm(mocha)
BuildRequires:  npm(pre-commit)
%endif
BuildArch:     noarch
Source44: import.info

%description
Ultron is a high-intelligence robot. It gathers intelligence
so it can start improving upon his rudimentary design. It will
learn your event emitting patterns and find ways to exterminate
them. Allowing you to remove only the event emitters that you
assigned and not the ones that your users or developers assigned.
This can prevent race conditions, memory leaks and even file
descriptor leaks from ever happening as you won't remove clean
up processes.

%prep
%setup -q -n package
# Copy test.js
cp -ap %{SOURCE1} .
# Copy README.md
cp -ap %{SOURCE2} .

%build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{npm_name}
cp -pr index.js package.json test.js %{buildroot}%{nodejs_sitelib}/%{npm_name}


%if 0%{?enable_tests}
%check
mocha --reporter spec --ui bdd test.js
%endif

%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{npm_name}

%changelog
