Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename vlq

# We'll bootstrap for now with the file in the dist/ directory, but if/when
# npm(rollup) gets packaged, we'll be able to rebuild dist/ from src/
%global bootstrap 0

%global enable_tests 1

Name:		nodejs-vlq
Version:	0.2.2
Release:	alt1_6
Summary:	Generate, and decode, base64 VLQ mappings for source maps and other uses

License:	MIT
URL:		https://github.com/Rich-Harris/vlq
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh
# License file requested at https://github.com/Rich-Harris/vlq/issues/5
Source11:	LICENSE-MIT.txt


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel

%if 0%{?bootstrap}
# nothing
%else
BuildRequires:	npm(rollup)
%endif

%if 0%{?enable_tests}
#BuildRequires:	
%endif
Source44: import.info

%description
Generate, and decode, base64 VLQ mappings for source maps and other uses


%prep
%setup -q -n package

# setup the tests
%setup -q -T -D -a 1 -n package

# license file
cp -p %{SOURCE11} .
%if 0%{?bootstrap}
# nothing
%else
rm dist/*.js
%endif

%build
%if 0%{?bootstrap}
# nothing to do
%else
# This originally used esperanto to build, but rollup has replaced esperanto
#esperanto -i src/vlq.js -o dist/vlq.js -t umd -n vlq -s
%{_bindir}/rollup src/vlq.js -n vlq -f umd > dist/vlq.js
%endif

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json dist/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{__nodejs} test/
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc *.md
%doc --no-dereference LICENSE-MIT.txt
%{nodejs_sitelib}/%{packagename}

%changelog
