Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global enable_tests 0

%global barename vow-queue

Name:               nodejs-vow-queue
Version:            0.4.1
Release:            alt1_11
Summary:            Vow-based task queue

License:            MIT and GPLv3+
URL:                https://www.npmjs.org/package/vow-queue
Source0:            http://registry.npmjs.org/%{barename}/-/%{barename}-%{version}.tgz
BuildArch:          noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel

BuildRequires:      npm(vow)

Requires:           npm(vow)

%if 0%{?enable_tests}
BuildRequires:      npm(jscs)
BuildRequires:      npm(vow)
BuildRequires:      npm(jshint)
BuildRequires:      npm(istanbul)
BuildRequires:      npm(mocha-istanbul)
BuildRequires:      npm(chai)
BuildRequires:      npm(mocha)
%endif
Source44: import.info


%description
vow-queue is a module for task queue with weights and priorities

%prep
%setup -q -n package

# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep --caret

%build
%nodejs_symlink_deps --build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/vow-queue
cp -pr package.json lib \
    %{buildroot}%{nodejs_sitelib}/vow-queue

%nodejs_symlink_deps


%check
%if 0%{?enable_tests}
%nodejs_symlink_deps --check
make validate
%endif


%files
%doc CHANGELOG.md README.md LICENSE
%{nodejs_sitelib}/vow-queue/

%changelog
