Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename watershed
%global enable_tests 1

Name:		nodejs-watershed
Version:	0.3.4
Release:	alt1_6
Summary:	A simple websockets (RFC6455) client and server

License:	MIT
URL:		https://github.com/joyent/node-watershed
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh
# One test file is missing in the 0.3.4 release
Source11:	https://raw.githubusercontent.com/joyent/node-watershed/master/test/basic.js


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	npm(tape)
%endif
Source44: import.info

%description
A simple websockets (RFC6455) client and server.


%prep
%setup -q -n package

# setup the tests
%setup -q -T -D -a 1 -n package

cp %{SOURCE11} test/basic.js

%nodejs_fixdep readable-stream
# dtrace-provider doesn't work on Linux, and isn't really needed
%nodejs_fixdep -r dtrace-provider

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/tape test/basic.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
