Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-weak-map
Version:    1.0.5
Release:    alt1_10
Summary:    A WeakMap shim for Node.js and browsers
License:    ASL 2.0
URL:        https://github.com/drses/weak-map
Source0:    http://registry.npmjs.org/weak-map/-/weak-map-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-v%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
Source44: import.info

%description
WeakMap is a collection introduced to JavaScript with EcmaScript 6. It
provides a mapping from objects to values, but allows any entry to be
garbage collected if the key is provably lost.

In order for it to be possible that a key is provably lost, weak maps
do not provide a way to access the key list.

This is a Node.js module that provides a shim and patcher for missing
or broken WeakMap implementations, suitable for use in Node.js and
browsers that provide the EcmaScript 5 property description interfaces.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/weak-map
cp -pr package.json weak-map.js \
    %{buildroot}%{nodejs_sitelib}/weak-map

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
#  /usr/bin/npm install jasminum@^2.0.1
#  mkdir -p node_modules/jasminum/node_modules/collections/node_modules
#  ln -sf %%{_builddir}/package \
#     node_modules/jasminum/node_modules/collections/node_modules/weak-map
%__nodejs --harmony_collections test/index.js
%__nodejs test/index.js
%endif


%files
%doc README.md
%{nodejs_sitelib}/weak-map


%changelog
