Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packagename when
%global enable_tests 0
# tests disabled due to missing dependency on npm(buster)

Name:		nodejs-%{packagename}
Version:	3.7.7
Release:	alt1_10
Summary:	A lightweight Promises/A+ and when() implementation

License:	MIT
URL:		https://github.com/cujojs/when
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source2:    docs-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:	noarch
BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	node-mocha
BuildRequires:	nodejs-buster
%endif
Requires:	node
Source44: import.info

%description
When.js is a rock solid, battle-tested Promises/A+ and when() implementation,
including a complete ES6 Promise shim. It's a powerful combination of small
size, high performance, debuggability, and rich features:

 * Resolve arrays and hashes of promises, as well as infinite promise sequences
 * Execute tasks in parallel or sequentially
 * Transform Node-style and other callback-based APIs into promise-based APIs

When.js is one of the many stand-alone components of cujoJS, the JavaScript
Architectural Toolkit.

%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
%setup -q -T -D -a 2 -n package


%build
# nothing to do to build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js lib/ node/ unfold/ monitor/ es6-shim/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
NODE_ENV=test /usr/bin/mocha -R spec
%endif


%files
%{!?_licensedir:%global license %doc}
%doc README.md CHANGES.md docs/
%doc --no-dereference LICENSE.txt
%{nodejs_sitelib}/%{packagename}



%changelog
