Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-winston
Version:    0.7.3
Release:    alt1_12
Summary:    A multiple transport asynchronous logging library for Node.js
License:    MIT
URL:        https://github.com/flatiron/winston
Source0:    http://registry.npmjs.org/winston/-/winston-%{version}.tgz

Patch0:     %{name}-0.7.2-Remove-stream-tests.patch
Patch1:     %{name}-0.7.3-Shutdown-server.patch

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(async)
BuildRequires:  npm(colors)
BuildRequires:  npm(combined-stream)
BuildRequires:  npm(cycle)
BuildRequires:  npm(eyes)
BuildRequires:  npm(pkginfo)
BuildRequires:  npm(stack-trace)
BuildRequires:  npm(vows)
%endif
Source44: import.info

%description
This module is a multiple transport asynchronous logging library for Node.js.

Winston is designed to be a simple and universal logging library with support
for multiple transports. A transport is essentially a storage device for your
logs. Each instance of a winston logger can have multiple transports
configured at different levels. For example, one may want error logs to be
stored in a persistent remote location (like a database), but all logs output
to the console or a local file.

There also seemed to be a lot of logging libraries out there that coupled
their implementation of logging (ie, how the logs are stored/indexed) to the
API that they exposed to the programmer. This library aims to decouple those
parts of the process to make it more flexible and extensible.


%prep
%setup -q -n package
find . -type f -iname '*.js' -exec chmod -x '{}' \;
%patch0 -p1
%patch1 -p1
%nodejs_fixdep async '^1.5.0'
%nodejs_fixdep colors '^1.1.2'
%nodejs_fixdep request '^2.14'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/winston
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/winston

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
rm -f test/transports/webhook-test.js
%{nodejs_sitelib}/vows/bin/vows --spec --isolate
%endif


%files
%doc CHANGELOG.md LICENSE README.md docs/ examples/
%{nodejs_sitelib}/winston


%changelog
