Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-nodejs
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nodejs-zipfile
Version:        0.5.12
Release:        alt3_6
Summary:        C++ library for handling zipfiles in Node.js

License:        BSD
URL:            https://github.com/mapbox/node-zipfile
Source0:        https://github.com/mapbox/node-zipfile/archive/v%{version}/node-zipfile-%{version}.tar.gz
Patch0:         nodejs-zipfile-pregyp.patch
# https://github.com/mapbox/node-zipfile/pull/82
Patch1:         nodejs-zipfile-node12.patch

BuildRequires:  node-devel rpm-build-nodejs
BuildRequires:  node-gyp
BuildRequires:  libzip-devel >= 0.11.2
BuildRequires:  zlib-devel

BuildRequires:  npm(nan) >= 2.14.0
BuildRequires:  npm(mocha)
BuildRequires:  npm(mkdirp)

%{?nodejs_default_filter}
Source44: import.info

%description
Bindings to libzip for handling zipfile archives in Node.js.


%prep
%setup -q -n node-zipfile-%{version}
%patch0 -p1
%patch1 -p1

%nodejs_fixdep -r nan
%nodejs_fixdep --dev nan "^2.4.0"
rm -rf deps/* node_modules
echo "{}" > deps/common-libzip.gypi


%build
%nodejs_symlink_deps --build
export CXXFLAGS="%{optflags} -I/usr/include/libzip -I%_libdir/libzip/include"
export LDFLAGS="%{?__global_ldflags} -Wl,-z,undefs"
node-gyp configure -- -Dshared_libzip=true -Dmodule_name=zipfile -Dmodule_path=lib/binding
node-gyp build


%install
mkdir -p %{buildroot}/%{nodejs_sitearch}/zipfile
cp -pr package.json lib %{buildroot}/%{nodejs_sitearch}/zipfile
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/mocha/bin/mocha -R spec


%files
%doc README.md
%doc --no-dereference LICENSE.txt
%{nodejs_sitearch}/zipfile


%changelog
