# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-helper
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define rel 0.12
%add_optflags -fcommon

Name:		novacom-server
Version:	1.1.0
Release:	alt1_%{rel}
Summary:	Service for utility that connects to WebOS devices
Group:		Development/Tools
License:	Apache License
URL:		https://github.com/openwebos/novacomd
Source0:	https://github.com/openwebos/novacomd/tarball/versions/1.1.0-rc1/openwebos-novacomd-submissions-119.1-0-ge77d336.tar.gz
Source1:	novacomd.service
Source2:	config-novacomd
# This patch allows novacomd to work against Fedora's libusb
Patch0:		0001-Use-usb_bulk_-read-write-instead-of-homemade-handler.patch
# This patch forces the makefile to use our CFLAGS
Patch1:		novacomd_add_cflags.patch
# This patch muffles the logging of every packet to the device
Patch2:		novacomd-quiet-logging.patch
# This patch removes unused adler32 library from the makefile
Patch3:		novacomd-makefile-remove-adler32.patch
Provides:	novacomd = %{version}-%{release}
BuildRequires:	pkgconfig(libusb)
Source44: import.info

%description
This novacomd service allows the novacom client to connect to WebOS
devices that are connected over USB.

%prep
%setup -q -n openwebos-novacomd-e77d336
%patch0  -p1
%patch1  -p1
%patch2  -p1
%patch3  -p1
# Remove unused and unneeded zlib headers and adler32 library
rm -f src/lib/cksum/adler32.c
rm -f src/lib/cksum/zlib.h

%build
%make_build host LDFLAGS="$RPM_OPT_FLAGS" CFLAGS="$RPM_OPT_FLAGS -std=gnu17"

%install
mkdir -p %{buildroot}%{_bindir}
install -pm 755 build-novacomd-host/novacomd %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_unitdir}
install -pm 644 %{SOURCE1} %{buildroot}%{_unitdir}
mkdir -p %{buildroot}%{_sysconfdir}/default
install -pm 644 %{SOURCE2} %{buildroot}%{_sysconfdir}/default/novacomd

%post
%_post_service novacomd
 
%preun
%_preun_service novacomd

%files
%doc README.md
%{_bindir}/novacomd
%{_unitdir}/novacomd.service
%config(noreplace) %{_sysconfdir}/default/novacomd



%changelog
