Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires: unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nqc
Version:        3.1.7
Release:        alt2_40
Summary:        Not Quite C compiler

# Automatically converted from old format: MPLv1.0 - review is highly recommended.
License:        LicenseRef-Callaway-MPLv1.0
URL:            http://bricxcc.sourceforge.net/nqc/
Source0:        http://bricxcc.sourceforge.net/nqc/release/nqc-3.1.r6.tgz
Source1:        60-legousbtower.rules
Source2:        http://bricxcc.sourceforge.net/nqc/doc/faq.html
Source3:        http://bricxcc.sourceforge.net/nqc/doc/NQC_Manual.pdf
Source4:        http://bricxcc.sourceforge.net/nqc/doc/NQC_Guide.pdf
Source5:        http://bricxcc.sourceforge.net/nqc/doc/NQC_Tutorial.pdf
Source6:        http://bricxcc.sourceforge.net/nqc/doc/NQCTutorialSamples.zip
Source7:        http://people.cs.uu.nl/markov/lego/tutorial_n.doc
Source8:        http://people.cs.uu.nl/markov/lego/tutorial_d.doc
Source9:        http://people.cs.uu.nl/markov/lego/tutorial_j.pdf
Source10:       http://people.cs.uu.nl/markov/lego/tutorial_s.doc
Source11:       http://people.cs.uu.nl/markov/lego/tutorial_i.doc
Source12:       http://people.cs.uu.nl/markov/lego/tutorial_t.doc
Source13:       http://people.cs.uu.nl/markov/lego/tutorial_p.pdf
Patch0:         nqc-3.1.6-linux.patch
Patch1:         nqc-3.1.6.gcc47.patch
Patch2:         nqc-3.1.6-unistd.patch
BuildRequires:  gcc-c++
BuildRequires:  flex >= 2.5 
BuildRequires:  bison
BuildRequires:  rpm-macros-systemd
Source44: import.info

%description
Not Quite C is a simple language with a C-like syntax that can be used to
program Lego's RCX programmable brick (from the Mindstorms set).

%package        doc
Group: Documentation
Summary:        English Documentation for NQC
BuildArch: noarch

%description    doc
English Documentation for NQC

%package        doc-nl
Group: Documentation
Summary:        Dutch Documentation for NQC

%description	doc-nl
Dutch Documentation for NQC

%package        doc-de
Group: Documentation
Summary:        German Documentation for NQC

%description	doc-de
German Documentation for NQC

%package        doc-ja
Group: Documentation
Summary:        Japanese Documentation for NQC

%description	doc-ja
Japanese Documentation for NQC

%package        doc-es
Group: Documentation
Summary:        Spanish Documentation for NQC

%description	doc-es
Spanish Documentation for NQC

%package        doc-it
Group: Documentation
Summary:        Italian Documentation for NQC

%description	doc-it
Italian Documentation for NQC

%package        doc-th
Group: Documentation
Summary:        Thai Documentation for NQC

%description	doc-th
Thai Documentation for NQC

%package        doc-pt
Group: Documentation
Summary:        Portuguese Documentation for NQC

%description	doc-pt
Portuguese Documentation for NQC

%prep
%setup -c -q -n nqc-3.1.r6
%patch0  -p1
%patch1  -p0
%patch2  -p0 -b .isatty

for i in %{SOURCE2} %{SOURCE3} %{SOURCE4} %{SOURCE5}; do
  cp --preserve=timestamps $i .
done

cp --preserve=timestamps %{SOURCE7} ./nqc-tutorial-nl.doc
cp --preserve=timestamps %{SOURCE8} ./nqc-tutorial-de.doc
cp --preserve=timestamps %{SOURCE9} ./nqc-tutorial-ja.pdf
cp --preserve=timestamps %{SOURCE10} ./nqc-tutorial-es.doc
cp --preserve=timestamps %{SOURCE11} ./nqc-tutorial-it.doc
cp --preserve=timestamps %{SOURCE12} ./nqc-tutorial-th.doc
cp --preserve=timestamps %{SOURCE13} ./nqc-tutorial-pt.pdf

mkdir tutorial_files
unzip -qq -a %{SOURCE6} -d tutorial_files


# This piece of software seems to come from the Dark Side. Fix permissions and
# line endings.
find -type f -exec chmod 644 {} \; -exec perl -pi -e 's/\r\n/\n/g' {} \;

# Create a sysusers.d config file
cat >nqc.sysusers.conf <<EOF
g lego -
EOF


%build
%make_build

%install
%makeinstall_std PREFIX=%{buildroot}%{_prefix} MANDIR=%{buildroot}%{_mandir}/man1
rm %{buildroot}%{_bindir}/mkdata
install -p -m0644 -D %{SOURCE1} %{buildroot}%{_udevrulesdir}/60-legousbtower.rules
install -m0644 -D nqc.sysusers.conf %{buildroot}%{_sysusersdir}/nqc.conf

%files
%{_bindir}/nqc
%{_mandir}/man1/nqc.1*
%{_udevrulesdir}/60-legousbtower.rules
%doc readme.txt LICENSE
%{_sysusersdir}/nqc.conf

%files doc
%doc scout.txt history.txt test.nqc
%doc faq.html NQC_Manual.pdf NQC_Guide.pdf NQC_Tutorial.pdf tutorial_files/

%files doc-nl
%lang(nl) %doc nqc-tutorial-nl.doc

%files doc-de
%lang(de) %doc nqc-tutorial-de.doc

%files doc-ja
%lang(ja) %doc nqc-tutorial-ja.pdf

%files doc-es
%lang(es) %doc nqc-tutorial-es.doc

%files doc-it
%lang(it) %doc nqc-tutorial-it.doc

%files doc-th
%lang(th) %doc nqc-tutorial-th.doc

%files doc-pt
%lang(pt) %doc nqc-tutorial-pt.pdf

%changelog
