# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/pkg-config gcc-c++
# END SourceDeps(oneline)
Name:           nss_compat_ossl
Version:        0.9.6
Release:        alt1_9
Summary:        Source-level compatibility library for OpenSSL to NSS porting

Group:          System/Libraries
License:        MIT
URL:            http://rcritten.fedorapeople.org/nss_compat_ossl.html
Source0:        http://rcritten.fedorapeople.org/%{name}-%{version}.tar.gz

# Need > 3.11.7-7 so we have the NSS PKCS#11 flat-file reader available 
BuildRequires:  nss-devel > 3.11.7-7
BuildRequires:  libnspr-devel

Patch0:         %{name}-%{version}-bz1099423.patch
Source44: import.info

%description
This library provides a source-level compatibility layer to aid porting
programs that use OpenSSL to use the NSS instead.

%package devel
Summary:          Development libraries for nss_compat_ossl
Group:            Development/C
Requires:         %{name} = %{version}-%{release}

%description devel
Header and library files for doing porting work from OpenSSL to NSS.

%prep
%setup -q

%patch0 -p1

%build

CFLAGS="$RPM_OPT_FLAGS -DPKCS11_PEM_MODULE"
export CFLAGS

%configure --prefix=/usr --disable-static
make %{?_smp_mflags}


%install
make install DESTDIR=$RPM_BUILD_ROOT

# We don't want to ship the .la file
rm $RPM_BUILD_ROOT/%{_libdir}/libnss_compat_ossl.la


%files
%{_libdir}/libnss_compat_ossl.so.*
%doc README COPYING

%files devel
%dir %{_includedir}/nss_compat_ossl
%{_includedir}/nss_compat_ossl/nss_compat_ossl.h
%{_libdir}/libnss_compat_ossl.so

%changelog
