Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# OCaml packages not built on i686 since OCaml 5 / Fedora 39.
ExcludeArch: %{ix86}

# OCaml 5.x support was added after the most recent release
%global commit  58459992ee9b3d56f09f6ff3dd434a52657b836c
%global date    20230115
%global forgeurl https://github.com/ocaml-obuild/obuild

# The binary is OCaml bytecode
%global debug_package %{nil}

Name:           ocaml-obuild
Version:        0.1.10
Summary:        Simple package build system for OCaml

# FedoraForgeMeta2ALT: generated meta
%global forgeurl https://github.com/ocaml-obuild/obuild
%global forgesource https://github.com/ocaml-obuild/obuild/archive/58459992ee9b3d56f09f6ff3dd434a52657b836c/obuild-58459992ee9b3d56f09f6ff3dd434a52657b836c.tar.gz
%global archivename obuild-58459992ee9b3d56f09f6ff3dd434a52657b836c
%global archiveext tar.gz
%global archiveurl https://github.com/ocaml-obuild/obuild/archive/58459992ee9b3d56f09f6ff3dd434a52657b836c/obuild-58459992ee9b3d56f09f6ff3dd434a52657b836c.tar.gz
%global topdir obuild-58459992ee9b3d56f09f6ff3dd434a52657b836c
%global extractdir obuild-58459992ee9b3d56f09f6ff3dd434a52657b836c
%global repo obuild
#global owner %nil
#global namespace %nil
%global scm git
#global tag %nil
%global commit 58459992ee9b3d56f09f6ff3dd434a52657b836c
#global shortcommit %nil
#global branch %nil
%global version 0.1.10
%global date 20230115
%global distprefix 20230115git5845999
# FedoraForgeMeta2ALT: end generated meta

Release:        alt2_23
License:        BSD-2-Clause
URL:            https://github.com/ocaml-obuild/obuild
Source0:        %{forgesource}

# Fix a partial function application
# https://github.com/ocaml-obuild/obuild/issues/187
Patch0:         %{name}-partial.patch

BuildRequires:  ocaml ocaml-runtime
BuildRequires:  ocaml-findlib ocaml-findlib-devel
BuildRequires:  help2man

Requires:       ocaml-findlib
Source44: import.info

%description
A parallel, incremental and declarative build system for OCaml.

The goal is to make a very simple build system for users and developers of
OCaml libraries and programs.

Obuild acts as a building black box: users only declare what they want to
build and with which sources; the build system will consistently build it.

The design is based on Haskell's Cabal and borrows most of the layout and
way of working, adapting parts where necessary to fully support OCaml.


%prep
%setup -q -n obuild-58459992ee9b3d56f09f6ff3dd434a52657b836c
%patch0 -p1



%build
./bootstrap


%install
mkdir -p $RPM_BUILD_ROOT%{_bindir}
cp "dist/build/obuild/obuild" "dist/build/obuild-simple/obuild-simple" "$RPM_BUILD_ROOT%{_bindir}"

# generate manpages
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
help2man \
    --output "$RPM_BUILD_ROOT%{_mandir}/man1/obuild.1" \
    --name "parallel, incremental and declarative build system for OCaml" \
    --help-option "" \
    --no-discard-stderr \
    --no-info \
    dist/build/obuild/obuild
help2man \
    --output "$RPM_BUILD_ROOT%{_mandir}/man1/obuild-simple.1" \
    --name "simple package build system for OCaml" \
    --version-string " " \
    --no-discard-stderr \
    --no-info \
    dist/build/obuild-simple/obuild-simple


%files
%doc README.md OBUILD_SPEC.md DESIGN.md
%doc --no-dereference LICENSE
%{_bindir}/obuild*
%{_mandir}/man1/obuild*.1*


%changelog
