# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name ocs-url
%define sourcename %{name}-release

Summary:        An install helper program for OpenCollaborationServices
Name:           ocs-url
Version:        3.0.3
Release:        alt1_7
# qtil is under lgplv3 license
License:        GPLv3+ and LGPLv3+
Group:          System/Base
URL:            https://github.com/opendesktop/%{name}
Source0:        https://github.com/opendesktop/%{name}/archive/release-%{version}.tar.gz
# https://github.com/akiraohgaki/qtil
# got from scripts/import.sh script and xz archived.
# this is a build dep not included in source
Source1:        qtil.tar.xz

BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  pkgconfig(Qt5Network)
BuildRequires:  pkgconfig(Qt5Qml)
BuildRequires:  pkgconfig(Qt5Quick)
BuildRequires:  pkgconfig(Qt5Svg)
%rename xdgurl

Requires:       libqt5-qml libqt5-quick libqt5-quickparticles libqt5-quicktest
Requires:       qt5-quickcontrols
Source44: import.info

%description
%{name} is an install helper program for items served
on OpenCollaborationServices (OCS). It is an URL handler
for xdg:// and ocs:// scheme. It enables you to download
or install desktop stuff from opendesktop.org or other sites.

%prep
%setup -q -n %{sourcename}-%{version}

tar -xvf %{SOURCE1} -C lib/

%build
%qmake_qt5 PREFIX=%{_prefix}
%make_build

%install
%qmakeinstall_std

%files
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/scalable/apps/%{name}.svg


%changelog
