# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_without  tests

Name:           open-adventure
Version:        1.20
Release:        alt1_2
Summary:        Forward-port of Colossal Cave Adventure 2.5 from 1995
Group:          Games/Adventure
License:        BSD-2-Clause
URL:            http://www.catb.org/~esr/open-adventure/
Source0:        https://gitlab.com/esr/open-adventure/-/archive/%{version}/%{name}-%{version}.tar.gz
#http://www.catb.org/~esr/open-adventure/advent-%%{version}.tar.gz

BuildRequires:  desktop-file-utils
BuildRequires:  asciidoctor
BuildRequires:  pkgconfig(libedit)
BuildRequires:  python3-module-yaml
%{?with_tests:
BuildRequires:  cppcheck
BuildRequires:  python3-module-pylint }
Source44: import.info

%description
Colossal Cave Adventure, the 1995 430-point version.

This is the last descendent of the original 1976 Colossal Cave Adventure
worked on by the original authors - Crowther & Woods.  It has sometimes
been known as Adventure 2.5.  The original PDP-10 name 'advent' is used
for the built program to avoid collision with the BSD Games version (see
'adventure' in the bsd-games package).

%prep
%setup -q


%build

%make_build advent advent.6 cheat html

%install
install -D -m755 advent %{buildroot}%{_gamesbindir}/advent
ln -s advent %{buildroot}%{_gamesbindir}/%{name}
install -D -m755 cheat %{buildroot}%{_gamesbindir}/cheat

install -D -m644 advent.6 %{buildroot}%{_mandir}/man6/advent.6
ln -s advent.6 %{buildroot}%{_mandir}/man6/%{name}.6

install -D -m644 advent.svg %{buildroot}%{_iconsdir}/hicolor/scalable/apps/advent.svg
desktop-file-install advent.desktop

%check
%{?with_tests:
# Fix pylint false-positive errors.
py_E0606='  # pylint:  disable=E0606'
sed -e "/db\[\"motions\"\].*:/s/$/${py_E0606}/" -e "/locnames/s/$/${py_E0606}/" \
    -e "/msgnames/s/$/${py_E0606}/" -e "/objnames/s/$/${py_E0606}/" -i make_dungeon.py
sed -e "/ALLALIKE/s/$/${py_E0606}/" -e "/debug/s/$/${py_E0606}/" \
    -e "/startlocs/s/$/${py_E0606}/" -e "/objname/s/$/${py_E0606}/" -i make_graph.py
# Fix ccpcheck option format.
sed -e "s/template gcc/template=gcc/g" -i Makefile
# Fix extra space in file name line
sed -e "s/saveresume.*/saveresume_win.adv/" -i tests/saveresume.4.log
# Run tests with single thread.
make check || : }

%files
%doc *.adoc *.html
%doc --no-dereference COPYING
%{_gamesbindir}/advent
%{_gamesbindir}/%{name}
%{_gamesbindir}/cheat
%{_datadir}/applications/advent.desktop
%{_iconsdir}/hicolor/scalable/apps/advent.svg
%{_mandir}/man6/advent.6*
%{_mandir}/man6/%{name}.6*


%changelog
