# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ openmpi-devel python3-devel rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define piname	aisradar_pi
%define uname	AISradar_pi
%global ocpnlibscommit0 c1d82631756056437edc58235d9e1ff68b46ddf3

Name:		opencpn-ais-radar-plugin
Summary:	AIS radar view plugin for OpenCPN
Version:	1.4.19.0
Release:	alt1_3
License:	GPLv2
Group:		Sciences/Geosciences
URL:		https://opencpn.org/OpenCPN/plugins/aisradarview.html
Source0:	https://github.com/rgleason/%{uname}/archive/v%{version}/%{uname}-%{version}.tar.gz
Source1:    https://github.com/OpenCPN/opencpn-libs/archive/%{ocpnlibscommit0}/opencpn-libs-%{ocpnlibscommit0}.tar.gz
Patch0:     opencpn-libs-c1d8263-tinyxml.patch
Patch1:     opencpn-libs-c1d8263-json.patch
Patch2:     opencpn-libs-c1d8263-ocpn_plugin.patch
Patch3:     aisradar-Plugin-1.4.19.0-Configure.patch


BuildRequires:	ccmake cmake ctest
BuildRequires:	gettext gettext-tools
BuildRequires:	git
BuildRequires:	libwxBase3.2-devel libwxGTK3.2-devel
BuildRequires:	pkgconfig(bzip2)
BuildRequires:	pkgconfig(gl)
BuildRequires:	pkgconfig(glu)
BuildRequires:	pkgconfig(jsoncpp)
BuildRequires:  pkgconfig(sqlite3)
BuildRequires:	pkgconfig(tinyxml)
BuildRequires:	pkgconfig(zlib)

Requires:		opencpn
Provides:		%{piname} = %{version}
Source44: import.info

%description
AIS Radar is a plugin that allows the display of AIS targets in the way ships
are displayed on a radar screen.

North up, course up displays.

Includes the "Anchor" branch from TransmitterDan, which shows a black ball on
all AIS Class A vessels that are anchored or moored.

%prep
%setup -a1 -n %{uname}-%{version}

%patch0  -p1
%patch1  -p1
%patch2  -p1
%patch3  -p1

mv  opencpn-libs-%{ocpnlibscommit0}/{.,}* opencpn-libs/

%build
%{mageia_cmake}

%mageia_cmake_build

%install
%mageia_cmake_install

%ifarch x86_64 aarch64
mkdir -p %{buildroot}%{_libdir}/opencpn
mv %{buildroot}/usr/lib/opencpn/* %{buildroot}%{_libdir}/opencpn/
%endif

%find_lang opencpn-%{piname}

%files -f opencpn-%{piname}.lang
%{_libdir}/opencpn/lib%{piname}.so
%{_datadir}/opencpn/plugins/%{piname}/


%changelog
