# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ libgtest-devel openmpi-devel python3-devel rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global ocpnlibscommit0 433aed02b6dbf1b34709e44aea038f5c853bec79
%define piname	celestial_navigation_pi
%global  _disable_ld_as_needed 1

Name:		opencpn-celestial-navigation-plugin
Summary:	Celestial Navigation plugin for OpenCPN
Version:	2.4.65.0
Release:	alt1_1
License:	GPLv3+
Group:		Sciences/Geosciences
URL:		https://opencpn.org/OpenCPN/plugins/celestialnav.html
Source0:	https://github.com/rgleason/%{piname}/archive/v%{version}/%{piname}-%{version}.tar.gz
Source1:    https://github.com/OpenCPN/opencpn-libs/archive/%{ocpnlibscommit0}/opencpn-libs-%{ocpnlibscommit0}.tar.gz
Patch0:     opencpn-libs-433aed0-tinyxml.patch
Patch1:     opencpn-libs-433aed0-json.patch
Patch2:     opencpn-libs-433aed0-ocpn_plugin.patch
Patch3:     celestial-Plugin-2.4.65-Configure.patch

BuildRequires:	ccmake cmake ctest
BuildRequires:	gettext gettext-tools
BuildRequires:	libwxBase3.2-devel libwxGTK3.2-devel
BuildRequires:	pkgconfig(bzip2)
BuildRequires:	pkgconfig(gl)
BuildRequires:	pkgconfig(glu)
BuildRequires:  pkgconfig(jsoncpp)
BuildRequires:  pkgconfig(sqlite3)
BuildRequires:	pkgconfig(tinyxml)
BuildRequires:	pkgconfig(zlib)

Requires:	opencpn
Provides:   %{piname} = %{version}
Source44: import.info

%description
Implements nautical almanac for sun, moon, planets and various
navigational stars.

Enables the user to compute a position fix from celestial measurements.

%prep
%setup -a1 -n %{piname}-%{version}

%patch0  -p1
%patch1  -p1
%patch2  -p1
%patch3  -p1

mv opencpn-libs-%{ocpnlibscommit0}/{.,}* opencpn-libs/

%build
%{mageia_cmake}

%mageia_cmake_build

%install
%mageia_cmake_install

%find_lang opencpn-%{piname}

%ifarch x86_64 aarch64
mkdir -p %{buildroot}%{_libdir}/opencpn
mv %{buildroot}/usr/lib/opencpn/* %{buildroot}%{_libdir}/opencpn/
%endif

%files -f opencpn-%{piname}.lang
%{_libdir}/opencpn/lib%{piname}.so
%{_datadir}/opencpn/plugins/%{piname}/


%changelog
