# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install gcc-c++ imake libXt-devel xorg-cf-files
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define snapshot beta3

Name:           openuniverse
Version:        1.0
Release:        alt1_0.20.%{snapshot}
Summary:        OpenGL space simulator focused on the Solar System

Group:          Toys
License:        GPLv2+
URL:            http://www.openuniverse.org/
Source0:        http://download.sourceforge.net/openuniverse/%{name}-%{version}%{snapshot}.tar.gz
Source1:        openuniverse.1
Source2:        openuniverse.desktop
Patch0:         openuniverse-1.0beta3-strings.patch
Patch1:         openuniverse-1.0beta3-gl.patch
Patch2:         openuniverse-1.0beta3-yacc.patch
Patch3:         openuniverse-1.0beta3-paths.patch
Patch4:         format-fix.patch

BuildRequires:  desktop-file-utils
BuildRequires:  bison flex
BuildRequires:  libGL-devel
BuildRequires:  libGLU-devel
BuildRequires:  libfreeglut-devel
BuildRequires:  libXmu-devel
BuildRequires:  libjpeg-devel
BuildRequires:  libICE-devel
BuildRequires:  libSM-devel
BuildRequires:  libX11-devel
BuildRequires:  libXext-devel
BuildRequires:  libXi-devel
BuildRequires:  libXmu-devel
BuildRequires:  ImageMagick-tools
Source44: import.info


%description
OpenUniverse is a space simulator.  It currently focusses on the Solar
System and lets you visit all of its planets, major moons and a vast
collection of smaller bodies in colorful, glorious and realtime 3D.

If you've ever had a chance to visit Mercury or asteroid Geographos, here
you'll find them looking exactly the same way, following exactly the same
path as when you've left them.


%prep
%setup -q -n %{name}-%{version}%{snapshot}
%patch0 -p1 -b .strings
%patch1 -p1 -b .gl
%patch2 -p1 -b .yacc
%patch3 -p1 -b .paths
%patch4 -p0 -b .format-fix


%build
%configure
%make_build


%install
make install SHOTS_DIR=. DESTDIR=$RPM_BUILD_ROOT

# Manual
install -d $RPM_BUILD_ROOT%{_mandir}/man1
install -m 644 %{SOURCE1} $RPM_BUILD_ROOT%{_mandir}/man1

# Menu entry
desktop-file-install \
        --dir $RPM_BUILD_ROOT%{_datadir}/applications   \
        %{SOURCE2}

# Icon
install -d $RPM_BUILD_ROOT%{_datadir}/pixmaps
convert docs/cyclo.gif \
        $RPM_BUILD_ROOT%{_datadir}/pixmaps/openuniverse.png

# Fixup config file paths
install -d $RPM_BUILD_ROOT%{_sysconfdir}
mv $RPM_BUILD_ROOT%{_datadir}/openuniverse/conf/ou.conf \
       $RPM_BUILD_ROOT%{_sysconfdir}
rmdir $RPM_BUILD_ROOT%{_datadir}/openuniverse/conf



%files
%config(noreplace) %{_sysconfdir}/ou.conf
%{_bindir}/openuniverse
%{_datadir}/openuniverse
%{_mandir}/man1/openuniverse.1*
%{_datadir}/applications/*.desktop
%{_datadir}/pixmaps/*.png
%doc AUTHORS NEWS README ChangeLog COPYING INSTALL docs/manual.html
%doc %{_datadir}/openuniverse/docs


%changelog
