Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global commit f341f5f237737594c1b024338f0a2fc04fabdff3

Name:           osmctools
Version:        0.9
Release:        alt2_19
Summary:        Tools to manipulate OpenStreetMap files

# Debian man pages are GPLv2+
# Automatically converted from old format: AGPLv3 and GPLv2+ - review is highly recommended.
License:        AGPL-3.0-only AND GPL-2.0-or-later
URL:            https://gitlab.com/osm-c-tools/osmctools
Source0:        https://gitlab.com/osm-c-tools/osmctools/repository/archive.tar.gz?ref=%{version}#/%{name}-%{version}.tar.gz
# Man pages from Debian
Source1:        osmconvert.1
Source2:        osmfilter.1
Source3:        osmupdate.1
# Fix building with gcc 15
Patch0:         %{name}-0.9-gcc15.patch

BuildRequires:  gcc
BuildRequires:  zlib-devel
BuildRequires:  autoconf
BuildRequires:  automake
Requires:       wget
Source44: import.info


%description
Small collection of basic OpenStreetMap tools, include converter, filter and
updater files.

Programs include:
* osmconvert - Converter of OSM files
* osmfilter - The experimental OSM filters data
* osmupdate - Update OSM files.


%prep
%setup -q -n %{name}-%{version}-%{commit}
%patch0 -p1



%build
autoreconf -fvi
%configure
%make_build


%install
%makeinstall_std

# Install man pages
install -d %{buildroot}%{_mandir}/man1/
for i in %{SOURCE1} %{SOURCE2} %{SOURCE3}; do
  install -p -m 0644 ${i} %{buildroot}%{_mandir}/man1/
done


%files
%doc --no-dereference COPYING
%doc AUTHORS README.md
%{_bindir}/osmconvert
%{_bindir}/osmfilter
%{_bindir}/osmupdate
%{_mandir}/man1/osmconvert.1*
%{_mandir}/man1/osmfilter.1*
%{_mandir}/man1/osmupdate.1*


%changelog
