# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
Name: paco
Version: 2.0.9
Release: alt2_15
Summary: A source code package organizer for Unix/Linux

Group: File tools
License: GPLv2+
URL: http://paco.sourceforge.net/
Source0: http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.bz2

# Patches e-mailed to upstream on June 16, 2011
# Updates the GPLv2 license file to the newest revision
Patch0: paco-2.0.9-fix-fsf-address.patch
# Updates the gpaco.desktop file to fix errors in categorization and icon path
Patch1: paco-2.0.9-fix-desktop-file.patch
# Fixes glib header error on F17
Patch2: paco-2.0.9-fix-glib.patch

BuildRequires: libgtkmm2-devel
BuildRequires: desktop-file-utils
Source44: import.info

%description
After the installation of a source package with "./configure && make && make
install", one is usually left with having no idea of what it was installed and
where it all went, making it difficult to uninstall the package in the future.

Paco was written to solve this problem in a quite simple fashion.

When installing a package from sources, paco wraps the "make install" command
(or whatever command or group of commands are needed to install the files into
the system), and saves installation information into a text database.

Paco has many usage options for removing packages, looking at package files, 
file counts, sorting, missing files, etc. Run "paco -h" on the command line, 
or "man paco" for more information.


%package -n gpaco
Summary: GTK+ GUI for %{name}
Group: File tools
Requires: %{name}%{?_isa} = %{version}-%{release}

%description -n gpaco
The gpaco package contains the GTK+ based GUI for paco.


%prep
%setup -q
%patch0 -p0
%patch1 -p0
%patch2 -p0
iconv -f iso8859-1 -t utf-8 ChangeLog > ChangeLog.conv && touch -r ChangeLog ChangeLog.conv && mv -f ChangeLog.conv ChangeLog


%build
%configure
make %{?_smp_mflags}


%install
make install DESTDIR=%{buildroot}

desktop-file-install \
    --dir=%{buildroot}%{_datadir}/applications \
    %{buildroot}/%{_datadir}/applications/gpaco.desktop

# Unnecessary folder with duplicate files
rm -rf %{buildroot}%{_datadir}/paco
# Unnecessary library files
rm -f %{buildroot}%{_libdir}/*.la
rm -f %{buildroot}%{_libdir}/*.so
rm -f %{buildroot}%{_libdir}/*.a
rm -rf %{buildroot}%{_libdir}/pkgconfig


%files
%doc COPYING BUGS README ChangeLog doc/faq.txt
%{_bindir}/ocap
%{_bindir}/paco*
%{_bindir}/rpm2paco
%{_bindir}/superpaco
%{_libdir}/libpaco-log.so.*
%{_mandir}/man5/pacorc.5.*
%{_mandir}/man8/*.8*
%config(noreplace) %{_sysconfdir}/pacorc


%files -n gpaco
%{_bindir}/gpaco
%{_datadir}/pixmaps/gpaco*.png
%{_datadir}/applications/gpaco.desktop


%changelog
