Group: System/Libraries
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		pam_shield
Version:	0.9.5
Release:	alt2_32
Summary:	Pam Shield - A pam module to counter brute force attacks

License:	GPLv2
URL:		http://www.heiho.net/pam_shield/index.html
Source0:	http://www.heiho.net/pam_shield/pam_shield-0.9.5.tar.gz
Source1:	shield-trigger.8.gz
Source2:	shield-purge.8.gz
Source3:	shield-trigger-iptables.8.gz
BuildRequires:  gcc
BuildRequires:	libpam0-devel, libgdbm-devel
%if 0%{?rhel} <= 5
Requires:	policycoreutils
%else
Requires:	python3-module-policycoreutils
%endif
Patch0:		shield_purge_segfault.patch
Patch1:		shield-trigger-iptables.patch
Source44: import.info

%description
This is a pam module that supports brute force blocking against pam
authentication mechanisms.

%prep
%setup -q -n pam_shield-%{version}
mv GPL LICENSE
%patch0 -p0 -b .shield_purge_segfault
%patch1 -p0 -b .shield_trigger_iptables
#disable debug by default
sed -i -e 's/debug on/debug off/' shield.conf
#change to block all users for failed attempts
sed -i -e 's/block unknown-users/block all-users/' shield.conf
#reduce connections before block from 10 to 3
sed -i -e 's/max_conns 10/max_conns 3/' shield.conf
#reduce retention time from 1 week to 1 hour
sed -i -e 's/retention 1w/retention 1h/' shield.conf
#change the default behavior from shield-trigger to shield-trigger-iptables
#this uses iptables instead of route to block brute force attack
sed -i -e 's/shield\-trigger/shield-trigger-iptables/' shield.conf

%build
#software required -fPIC flag to build
make CFLAGS="%{optflags} -fPIC"

%install
mkdir -p -m 755 %{buildroot}%{_sysconfdir}/security
mkdir -p -m 755 %{buildroot}%{_sysconfdir}/cron.daily
mkdir -p -m 755 %{buildroot}%{_sbindir}
mkdir -p -m 755 %{buildroot}/%{_lib}/security
mkdir -p -m 755 %{buildroot}%{_mandir}/man8
install -m 755 pam_shield.so %{buildroot}/%{_lib}/security/
install -m 755 -T pam_shield.cron %{buildroot}%{_sysconfdir}/cron.daily/pam_shield
install -m 755 shield-trigger %{buildroot}%{_sbindir}/
install -m 755 shield-trigger-iptables %{buildroot}%{_sbindir}/
install -m 755 shield-purge %{buildroot}%{_sbindir}/
install -m 644 shield.conf %{buildroot}%{_sysconfdir}/security/
mkdir -p -m 700 %{buildroot}/var/lib/pam_shield
install -m 644 %{SOURCE1} %{buildroot}%{_mandir}/man8/
install -m 644 %{SOURCE2} %{buildroot}%{_mandir}/man8/
install -m 644 %{SOURCE3} %{buildroot}%{_mandir}/man8/

%post
semanage fcontext -a -t var_auth_t '/var/lib/pam_shield' 2>/dev/null || :
restorecon -R /var/lib/pam_shield || :

%postun
if [ $1 -eq 0 ] ; then
semanage fcontext -d -t var_auth_t '/var/lib/pam_shield' 2>/dev/null || :
if [ -e "/var/lib/pam_shield/db" ]
then
rm -f /var/lib/pam_shield/db
fi
fi

%files
/%{_lib}/security/pam_shield.so
%doc INSTALL README LICENSE CREDITS Changelog
%doc %{_mandir}/man8/shield-trigger.8*
%doc %{_mandir}/man8/shield-purge.8*
%doc %{_mandir}/man8/shield-trigger-iptables.8*
%config(noreplace) %{_sysconfdir}/security/shield.conf
%dir /var/lib/pam_shield
%{_sysconfdir}/cron.daily/pam_shield
%{_sbindir}/shield-trigger
%{_sbindir}/shield-purge
%{_sbindir}/shield-trigger-iptables

%changelog
