# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           pax-britannica
Version:        1.0.0
Release:        alt1_8
Summary:        Underwater one-button real-time strategy game
Group:          Games/Arcade
License:        MIT
URL:            http://paxbritannica.henk.ca/
# https://github.com/henkboom/pax-britannica commit a7a3c0c
Source0:        %{name}-%{version}.tar.xz
Source1:        %{name}.png

# Patches from Debian
Patch1:         compile_for_linux.patch
Patch2:         dont_static_compile.patch
Patch3:         add_manpage.patch
Patch4:         fix_including_extra_loaders.patch
Patch5:         load_resources_from_usr_share.patch
Patch6:         add_desktop_entry.patch
Patch7:         glfw3.patch

BuildRequires:  lua5.1-devel
BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(glfw3)
BuildRequires:  pkgconfig(glu)
BuildRequires:  pkgconfig(xrandr)
Source44: import.info

%description
Pax Britannica is a one-button real-time strategy game by No Fun Games.
Up to four players battle it out underwater, struggling to be the last one
standing!

Each player uses one button to spawn ships that fight automatically using the
latest in artificial aquatelligence technology. Gamepads are also supported.
The player who keeps their factory ship alive wins!

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1


%build

%make_build EXTRA_CFLAGS="$CFLAGS -I%{_includedir}/lua-5.1"

%install
install -D -m755 %{name} %{buildroot}%{_gamesbindir}/%{name}
install -D -m644 %{name}.desktop %{buildroot}%{_datadir}/applications/%{name}.desktop
install -D -m644 %{name}.6 %{buildroot}%{_mandir}/man6/%{name}.6
install -D -m644 %{_sourcedir}/%{name}.png %{buildroot}%_niconsdir/%{name}.png

install -d %{buildroot}%{_gamesdatadir}/%{name}
cp -a *.lua dokidoki components scripts sprites audio \
    %{buildroot}%{_gamesdatadir}/%{name}/

%files
%doc readme.txt
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/
%_niconsdir/%{name}.png
%{_mandir}/man6/%{name}.6*


%changelog
