# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define diskdev_cmds diskdev_cmds-208.11
%define ver 10

Summary:		A partitioning tool for Apple Macintosh-style partitioned disks
Name:			pdisk
Version:		0.10
Release:		alt1_1
License:		Apple Public Source License
Group:			System/Base
URL:			https://github.com/apple-oss-distributions/pdisk
Source0:		https://github.com/apple-oss-distributions/pdisk/archive/pdisk-%{ver}/pdisk-%{ver}.tar.gz
# This source is anavailable
Source1:		https://www.opensource.apple.com/darwinsource/tarballs/apsl/diskdev_cmds-208.11.tar.bz2

# From AUR
Patch0:			pdisk#makefile.patch
Patch1:			pdisk#file_media.c.patch
Patch2:			pdisk#cvt_pt.c.patch
Patch3:			pdisk#linux_strerror.patch
Patch4:			https://raw.githubusercontent.com/NixOS/nixpkgs/refs/heads/nixos-unstable/pkgs/by-name/pd/pdisk/cmdline.patch
# Patches for diskdev_cmds source.
Patch101:		diskdev_cmds.diff
Patch102:		pdisk-gcc-4.0.patch

BuildRequires:		pkgconfig(libbsd)
Source44: import.info

%description
pdisk enables you to view and modify Apple Macintosh-style partition maps.
Normally, it is used to create Linux partitions on your disk,
however, it can create partitions of any type, including HFS (except
it would be up to MacOS or some other tool to actually create the HFS
filesystem in that HFS partition). pdisk won't put MacOS disk drivers
onto your disk.

%prep
%setup -a1 -n pdisk-pdisk-%{ver}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

pushd %{diskdev_cmds}
%patch101 -p1
%patch102 -p1

popd

# Fix flags in makefile.
sed -e "s/^CFLAGS =/CFLAGS ?=/" -i makefile
sed -e "s/cc \(.*\) -o/cc \$(LDFLAGS) \1 -o/g" -i makefile

%build
export CFLAGS+=" -std=gnu17"
%make_build -f makefile
pushd %{diskdev_cmds}
%make_build -f Makefile.lnx
popd

%install
mkdir -p %{buildroot}/sbin
mkdir -p %{buildroot}%{_mandir}/man8
install -m755 pdisk %{buildroot}/sbin/pdisk
install -m755 pdisk %{buildroot}/sbin/cvt_pt
install -m444 pdisk.8 %{buildroot}%{_mandir}/man8
install -m755 %{diskdev_cmds}/fsck_hfs.tproj/fsck_hfs %{buildroot}/sbin
install -m755 %{diskdev_cmds}/newfs_hfs.tproj/newfs_hfs %{buildroot}/sbin
install -m444 %{diskdev_cmds}/newfs_hfs.tproj/newfs_hfs.8 %{buildroot}%{_mandir}/man8
chmod 0444 README pdisk.html

%files
%doc README pdisk.html
/sbin/pdisk
/sbin/cvt_pt
/sbin/newfs_hfs
/sbin/fsck_hfs

%{_mandir}/man8/pdisk.*
%{_mandir}/man8/newfs_hfs.*


%changelog
