Group: Networking/WWW
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           pen
Version:        0.34.1
Release:        alt2_9
Summary:        Load balancer for "simple" tcp based protocols such as http or smtp
License:        GPLv2
URL:            http://siag.nu/pen/
Source0:        http://siag.nu/pub/pen/%{name}-%{version}.tar.gz
Source1:        pen.httpd
BuildRequires:  libGeoIP-devel
BuildRequires:  libssl-devel
BuildRequires:  gcc
Requires:       apache2-base apache2-htcacheclean
Source44: import.info

%description
pen is a load balancer for "simple" tcp based protocols such as http or
smtp. It allows several servers to appear as one to the outside and 
automatically detects servers that are down and distributes clients among the
available servers. This gives high availability and scalable performance. 

%prep
%setup -q

# Convert to utf-8
for file in ChangeLog penctl.1; do
   mv $file timestamp
   iconv -f ISO-8859-1 -t UTF-8 -o $file timestamp
   touch -r timestamp $file
done

sed -i 's/\/var/\%{_localstatedir}/g' %{SOURCE1}
chmod 0644 penstats

%build
%configure --with-ssl --with-geoip
%make_build

%install
%makeinstall_std
install -pDm0755 penctl.cgi %{buildroot}%{_localstatedir}/www/pen/penctl.cgi
install -pDm0644 %{SOURCE1} %{buildroot}%{_sysconfdir}/httpd/conf.d/pen.conf

%files
%doc AUTHORS ChangeLog COPYING HOWTO penstats README TODO
%{_mandir}/man1/*
%{_bindir}/*
%config(noreplace) %{_sysconfdir}/httpd/conf.d/pen.conf
%{_localstatedir}/www/pen/
%exclude %{_prefix}/doc/

%changelog
