%define module_name AI-Embedding
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/CosineSimilarity.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Tiny.pm) perl(JSON/PP.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.11
Release: alt1
Summary: Perl module for working with text embeddings using various APIs
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BO/BOD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The the AI::Embedding manpage module provides an interface for working with text embeddings using various APIs. It currently supports the OpenAI Embeddings API. This module allows you to generate embeddings for text, compare embeddings, and calculate cosine similarity between embeddings.

Embeddings allow the meaning of passages of text to be compared for similarity.  This is more natural and useful to humans than using traditional keyword based comparisons.

An Embedding is a multi-dimensional vector representing the meaning of a piece of text.  The Embedding vector is created by an AI Model.  The default model (OpenAI's `text-embedding-ada-002') produces a 1536 dimensional vector.  The resulting vector can be obtained as a Perl array or a Comma Separated String. As the Embedding will typically be used homogeneously, having it as a CSV String is usually more convenient.  This is suitable for storing in a `TEXT' field of a database.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
