# BEGIN SourceDeps(oneline):
BuildRequires: libfann-devel libsowing-devel perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(GD.pm) perl(Test/More.pm) perl(XSLoader.pm) perl(constant.pm)
# END SourceDeps(oneline)
%define module_version 0.10
%define module_name AI-FANN
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt7
Summary: Perl wrapper for the Fast Artificial Neural Network library
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SALVA/%{module_name}-%{module_version}.tar.gz

%description
WARNING:  THIS IS A VERY EARLY RELEASE,
            MAY CONTAIN CRITICAL BUGS!!!

AI::FANN is a Perl wrapper for the Fast Artificial Neural Network
(FANN) Library available from http://fann.sourceforge.net:

  Fast Artificial Neural Network Library is a free open source neural
  network library, which implements multilayer artificial neural
  networks in C with support for both fully connected and sparsely
  connected networks. Cross-platform execution in both fixed and
  floating point are supported. It includes a framework for easy
  handling of training data sets. It is easy to use, versatile, well
  documented, and fast. PHP, C++, .NET, Python, Delphi, Octave, Ruby,
  Pure Data and Mathematica bindings are available. A reference manual
  accompanies the library with examples and recommendations on how to
  use the library. A graphical user interface is also available for
  the library.

AI::FANN object oriented interface provides an almost direct map to
the C library API. Some differences have been introduced to make it
more perlish:

=over 4

=item *

Two classes are used: `AI::FANN' that wraps the C `struct fann' type
and `AI::FANN::TrainData' that wraps `struct fann_train_data'.

=item *

Prefixes and common parts on the C function names referring to those
structures have been removed. For instance C
`fann_train_data_shuffle' becomes `AI::FANN::TrainData::shuffle' that
will be usually called as...

  $train_data->shuffle;

=item *

Pairs of C get/set functions are wrapped in Perl with dual accessor
methods named as the attribute (and without any `set_'/`get_'
prefix). For instance:

  $ann->bit_fail_limit($limit); # sets the bit_fail_limit

  $bfl = $ann->bit_fail_limit;  # gets the bit_fail_limit


Pairs of get/set functions requiring additional indexing arguments are
also wrapped inside dual accessors:

  # sets:
  $ann->neuron_activation_function($layer_ix, $neuron_ix, $actfunc);

  # gets:
  $af = $ann->neuron_activation_function($layer_ix, $neuron_ix);

Important: note that on the Perl version, the optional value argument
is moved to the last position (on the C version of the `set_' method
it is usually the second argument).

=item *

Some functions have been renamed to make the naming more consistent
and to follow Perl conventions:

  C                                      Perl
  -----------------------------------------------------------
  fann_create_from_file               => new_from_file
  fann_create_standard                => new_standard
  fann_get_num_input                  => num_inputs
  fann_get_activation_function        => neuron_activation_function
  fann_set_activation_function        => ^^^
  fann_set_activation_function_layer  => layer_activation_function
  fann_set_activation_function_hidden => hidden_activation_function
  fann_set_activation_function_output => output_activation_function

=item *

Boolean methods return true on success and undef on failure.

=item *

Any error reported from the C side is automaticaly converter to a Perl
exception. No manual error checking is required after calling FANN
functions.

=item *

Memory management is automatic, no need to call destroy methods.

=item *

Doubles are used for computations (using floats or fixed
point types is not supported).

=back


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
