# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(MIDI/Simple.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    AI-Gene-Sequence
%define upstream_version 0.22

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_11

Summary:    Base class of mutation methods
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/AI/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch: noarch
Source44: import.info

%description
This is a class which provides generic methods for the creation and
mutation of genetic sequences. Various mutations are provided but the
resulting mutations are not checked for a correct syntax. These classes are
suitable for genes where it is only necessary to know what lies at a given
position in a gene. If you need to ensure a gene maintains a sensible
grammar, then you should use the AI::Gene::Sequence class instead, the
interfaces are the same though so you will only need to modify your
overriding classes if you need to switch from one to the other.

A suitable use for this module might be a series of coefficients in a
polynomial expansion or notes to be played in a musical score.

This module should not be confused with the _bioperl_ modules which are
used to analyse DNA sequences.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml
%perl_vendor_privlib/*




%changelog
